* Confidence_intervals.sas;
options pageno=1 linesize=80;
goptions reset=all;
title 'Confidence intervals for elytra data';
data elytra;
	input length;
	datalines;
5.0
5.1
5.2
5.9
4.8
5.5
4.8
5.1
5.0
5.1
;
run;
* Print data set;
proc print data=elytra;
run;
* Generate 95% confidence intervals and plots;
title2 "95% confidence intervals";
proc univariate cibasic plots data=elytra;
	var length;
	histogram length / vscale=count normal(w=3) wbarline=3 waxis=3 height=4;
	qqplot length / normal waxis=3 height=4;
	symbol1 h=3;
run;
* Generate 99% confidence intervals;
title2 "99% confidence intervals";
proc univariate cibasic alpha = 0.01 data=elytra;
	var length;
run;
quit;
